/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure.generic;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.ivtoolkit.blocks.BlockStates;
import ivorius.ivtoolkit.random.WeightedSelector;
import ivorius.ivtoolkit.tools.MCRegistry;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.json.NBTToJson;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class WeightedBlockState
implements WeightedSelector.Item {
    private static Gson gson = WeightedBlockState.createGson();
    @Nullable
    public Double weight;
    @Nullable
    public IBlockState state;
    @Nullable
    public NBTTagCompound tileEntityInfo;

    public WeightedBlockState(@Nullable Double weight, @Nullable IBlockState state, @Nullable NBTTagCompound tileEntityInfo) {
        this.weight = weight;
        this.state = state;
        this.tileEntityInfo = tileEntityInfo;
    }

    public WeightedBlockState(MCRegistry registry, NBTTagCompound compound) {
        this.weight = compound.func_74764_b("weight") ? Double.valueOf(compound.func_74769_h("weight")) : null;
        Block block = compound.func_74764_b("block") ? registry.blockFromID(new ResourceLocation(compound.func_74779_i("block"))) : null;
        IBlockState iBlockState = this.state = block != null ? BlockStates.fromMetadata((Block)block, (int)compound.func_74762_e("meta")) : null;
        this.tileEntityInfo = compound.func_74764_b("tileEntityInfo") ? WeightedBlockState.tryParse(compound.func_74779_i("tileEntityInfo")) : (compound.func_74764_b("tileEntity") ? (NBTTagCompound)compound.func_74781_a("tileEntity") : null);
    }

    public static Gson createGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(WeightedBlockState.class, (Object)new Serializer(RecurrentComplex.specialRegistry));
        builder.registerTypeAdapter(WeightedBlockState.class, (Object)new Serializer(RecurrentComplex.specialRegistry));
        NBTToJson.registerSafeNBTSerializer(builder);
        return builder.create();
    }

    public static Gson getGson() {
        return gson;
    }

    public static NBTTagCompound tryParse(String json) {
        if (json.trim().length() == 0) {
            return null;
        }
        NBTTagCompound nbt = null;
        try {
            nbt = JsonToNBT.func_180713_a((String)json);
        }
        catch (NBTException nBTException) {
            // empty catch block
        }
        return nbt;
    }

    public double getWeight() {
        return this.weight != null ? this.weight : 1.0;
    }

    public NBTTagCompound writeToNBT(MCRegistry registry) {
        NBTTagCompound compound = new NBTTagCompound();
        if (this.weight != null) {
            compound.func_74780_a("weight", this.weight.doubleValue());
        }
        if (this.state != null) {
            compound.func_74778_a("block", registry.idFromBlock(this.state.func_177230_c()).toString());
            compound.func_74768_a("meta", BlockStates.toMetadata((IBlockState)this.state));
        }
        if (this.tileEntityInfo != null) {
            compound.func_74782_a("tileEntity", (NBTBase)this.tileEntityInfo);
        }
        return compound;
    }

    public WeightedBlockState copy() {
        return new WeightedBlockState(this.weight, this.state, this.tileEntityInfo != null ? this.tileEntityInfo.func_74737_b() : null);
    }

    public static class Serializer
    implements JsonDeserializer<WeightedBlockState>,
    JsonSerializer<WeightedBlockState> {
        private MCRegistry registry;

        public Serializer(MCRegistry registry) {
            this.registry = registry;
        }

        public WeightedBlockState deserialize(JsonElement jsonElement, Type par2Type, JsonDeserializationContext context) {
            JsonObject jsonObject = JsonUtils.asJsonObject(jsonElement, "blockState");
            Double weight = jsonObject.has("weight") ? Double.valueOf(JsonUtils.getDouble(jsonObject, "weight")) : null;
            IBlockState state = BlockStates.fromMetadata((Block)this.registry.blockFromID(new ResourceLocation(JsonUtils.getString(jsonObject, "block", "air"))), (int)JsonUtils.getInt(jsonObject, "metadata", 0));
            NBTTagCompound tileEntityInfo = JsonUtils.hasString(jsonObject, "tileEntityInfo") ? WeightedBlockState.tryParse(JsonUtils.getString(jsonObject, "tileEntityInfo")) : (jsonObject.has("tileEntity") ? (NBTTagCompound)WeightedBlockState.getGson().fromJson(jsonObject.get("tileEntity"), NBTTagCompound.class) : null);
            return new WeightedBlockState(weight, state, tileEntityInfo);
        }

        public JsonElement serialize(WeightedBlockState source, Type par2Type, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            if (source.weight != null) {
                jsonObject.addProperty("weight", (Number)source.weight);
            }
            jsonObject.addProperty("block", this.registry.idFromBlock(source.state.func_177230_c()).toString());
            jsonObject.addProperty("metadata", (Number)BlockStates.toMetadata((IBlockState)source.state));
            jsonObject.addProperty("tileEntity", gson.toJson((Object)source.tileEntityInfo));
            return jsonObject;
        }
    }
}

